
// run faildeps so that we fail early if there is a dependency problem
import $ivy.`org.openjfx:javafx-controls:12.0.2`
import com.digitalasset.canton.version.ReleaseVersion
type test = javafx.scene.control.TableCell[String,String]
import $ivy.`org.openjfx:javafx-controls:12.0.2`
import $ivy.`org.openjfx:javafx-base:12.0.2`
import $ivy.`org.openjfx:javafx-fxml:12.0.2`
import $ivy.`org.openjfx:javafx-media:12.0.2`
import $ivy.`org.openjfx:javafx-web:12.0.2`
import $ivy.`org.openjfx:javafx-graphics:12.0.2`
import $ivy.`org.scalafx::scalafx:12.0.2-R18`

val version = ReleaseVersion.current.fullVersion
val isIntegrationTest = sys.props.getOrElseUpdate("demo-test", "0") == "1"

// load JAR into process using ammonites magic @ and interp.load.cp
if(!isIntegrationTest) {
  val jarDir = os.Path(s"demo/lib/demo_2.13-${version}.jar", base=os.pwd)
  interp.load.cp(jarDir)
}

@

import com.digitalasset.canton.demo.{ReferenceDemoScript, DemoUI, DemoRunner, Notify}

// determine where the assets are
val location = sys.env.getOrElse("DEMO_ROOT", "demo")
val noPhoneHome = sys.env.keys.exists(_ == "NO_PHONE_HOME")

// start all nodes before starting the ui (the ui requires this)
val (maxWaitForPruning, bankingConnection, medicalConnection) = (ReferenceDemoScript.computeMaxWaitForPruning(medical.config.domainParameters), banking.sequencerConnection, medical.sequencerConnection)

val script = new ReferenceDemoScript(participants.all,
  bankingConnection, medicalConnection,
  location, maxWaitForPruning, medical.config.domainParameters.reconciliationInterval.unwrap,
  darPath = if(isIntegrationTest) Some( "./community/demo/target/scala-2.13/resource_managed/main") else None,
  additionalChecks = isIntegrationTest)
if(isIntegrationTest) {
  script.run()
} else {
  if(!noPhoneHome) {
    Notify.send()
  }
  val runner = new DemoRunner(new DemoUI(script))
  runner.startBackground()
}